<?php
/**
 * @name SMART CHAT
 * @description простой чат
 */
if( !defined('DATALIFEENGINE') ) {
    header( "HTTP/1.1 403 Forbidden" );
    header ( 'Location: ../../' );
    die( "Hacking attempt!" );
}


class Smartchat{

    const CONFIG = SC_CONFIG;
    private $db;
    private $member_id;


    public function __construct(){

        global $db, $member_id;
        $this->db = $db;
        $this->member_id = $member_id;
    }


    /**
     * @param null $limit
     * @return array|null
     * =========================
     * @name получение сообщений
     */
    public function getMessages($limit = null){

        $limit = (!$limit) ? self::CONFIG['limit_msg'] : $limit;

        return array_reverse($this->db->super_query("SELECT s.*, u.user_id, u.name, u.foto, u.fullname FROM " . USERPREFIX . "_smartchat s LEFT JOIN ".USERPREFIX."_users u ON s.user_id = u.user_id ORDER BY id DESC LIMIT " . $limit, true));

    }


    /**
     * @param $message
     * ===============================
     * @name обавление сообщения в чат
     */
    public function addMessage($message){

        $message = trim(htmlspecialchars(strip_tags($message)));
        $time = time();

        $this->db->query("INSERT INTO " . PREFIX . "_smartchat (user_id, message, time) VALUES ('{$_COOKIE["dle_user_id"]}', '{$message}', '{$time}')");

    }


    /**
     * @param $id
     * @return array|bool|mysqli_result
     * ========================
     * @name удаление сообщения
     */
    public function deleteMessage($id){

        $id = (int)$id;

        if($this->member_id){
            if($this->member_id["user_group"] == '1'){
                return $this->db->query("DELETE FROM " . PREFIX . "_smartchat WHERE id = '{$id}'");
            }
        }

        return null;
    }


    /**
     * @param $user_id
     * @param bool $ban
     * @return array|bool|mysqli_result|null
     * =============================
     * @name блокировка пользователя
     */
    public function ban($user_id, $ban = true){

        $user_id = (int)$user_id;

        $ban = ($ban == true) ? 'ban' : '';

        if($this->member_id){
            if($this->member_id["user_group"] == '1'){
                return $this->db->query("UPDATE " . USERPREFIX . "_users SET smartchat = '{$ban}' WHERE user_id = '{$user_id}'");
            }
        }

        return null;
    }

}