$(function(){

    let update = $('[data-update]').attr('data-update');
    let div = $("#chat_content");
    div.scrollTop(div.prop('scrollHeight'));


    function SmartChat(postData){

        let result = null;

        $.ajax({
            type: 'POST',
            url: window.location.href,
            data: postData,
            async: false, // возвращает полученый результат
            dataType: 'text',
            success: function(data){
                result = data;
            },
            error: function(data){
                console.log(data);
            }
        });

        return result;
    }


    // Отправка сообщения в чате по нажатию на Enter
    $(document).on("keydown", '[name="chat_message"]', function (e) {

        if (e.keyCode == 13) {

            let message = $(this).val();
            let response = SmartChat({"smartchat": "addMessage", "msg": message});
            response = response.split(":::");
            $('#chat_content').html(response[0]);
            $('#chat_users').html(response[1]);
            div.scrollTop(div.prop('scrollHeight'));
            $(this).val('');

            return false;
        }
    });

    // обновление сообщений
    setInterval(function(){
        let response = SmartChat({"smartchat": "getMessages"});
        response = response.split(":::");
        $('#chat_content').html(response[0]);
        $('#chat_users').html(response[1]);

        let s_top = $("#chat_content").scrollTop();
        let yes = $("#chat_content ul li:last").offset().top;
        if(s_top > yes){
            div.scrollTop(div.prop('scrollHeight'));
        }

    }, update)


    // удаление сообщения
    $(document).on("click", ".sc_delete", function(){
        let id = $(this).parent().parent().attr("data-id");
        let response = SmartChat({"smartchat": "deleteMessage", "id": id});
        if(response == "ok") $(this).parents("li").remove();
        return false;
    })


    // блокировка пользователя
    $(document).on("click", ".sc_ban", function(){
        let id = $(this).attr("data-user");
        let response = SmartChat({"smartchat": "ban", "id": id});
        console.log(response);
        if(response == "ok") alert("Пользователь заблокирован!");
        return false;
    })

})